@echo off

:: Display header information
echo -----------------------------------------
echo ThingLabs Binaries Flashing Tool
echo Version: 1.0
echo Preset Image: 8.9.2
echo Last binaries/updated: 11/4/2024
echo Support Discord: https://tl.mt/d
echo Operating System: WINDOWS
echo -----------------------------------------

:: Instructions block
echo Instructions for use:
echo 1. Go to https://zadig.akeo.ie/ and download Zadig.
echo 2. Connect Car Thing in burn mode (Holding buttons 1 and 4 while plugging in).
echo 3. Select "Show All Devices" in zadig and select GX-CHIP.
echo 4. Check the "Edit" checkbox and rename "GX-CHIP" to "WorldCup Device".
echo 5. Use the up/down arrows on the driver to select "libusb-win32" as the driver.
echo 6. Hit Replace Driver or Install Driver and wait for the install to finish.
echo 7. Run this script.
echo.

:: Something Went Wrong block
echo If the process does not work, there are a few things to try:
echo - Try again. Unplug and plug in the device and run this script again
echo - Try a better cable. The Car Thing requires a lot of power, ensure you are using a port on the back of your computer.
echo - Try a different pot
echo - Try a powered USB hub
echo - Use device manager to "Uninstall Device" on the car thing. Repeat this until no device is found. Then, repeat steps 3 onwards
echo - Try an INTEL based computer (AMD 5000 series chips have an issue flashing)
echo - (AMD Systems) Try updating your BIOS
echo - (AMD Systems) Try enabling virtualization in BIOS
echo.

echo =================================
echo Placing device into USB Burn Mode
echo =================================
powershell -command "./binaries/update.exe write images\superbird.bl2.encrypted.bin 0xfffa0000 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"

powershell -command "./binaries/update.exe run 0xfffa0000 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"

echo Sleeping for 3 seconds while device boots BL2 stage.
timeout /t 3 /nobreak >nul
powershell -command "./binaries/update.exe bl2_boot images\superbird.bootloader.img 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"

echo Sleeping for 10 seconds while device boots BL3 stage (USB Burn).
timeout /t 10 /nobreak >nul

echo ========================================
echo Placing device into Partition Management
echo ========================================
powershell -command "./binaries/update.exe bulkcmd 'amlmmc part 1' 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"

echo =========================
echo Uploading Image to Device
echo =========================
powershell -command "./binaries/update.exe partition boot_a flash\boot_a.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition boot_b flash\boot_b.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition data flash\data.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition dtbo_a flash\dtbo_a.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition dtbo_b flash\dtbo_b.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition env flash\env.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition fip_a flash\fip_a.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition fip_b flash\fip_b.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition logo flash\logo.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition misc flash\misc.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition settings flash\settings.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition system_a flash\system_a.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition system_b flash\system_b.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition vbmeta_a flash\vbmeta_a.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
powershell -command "./binaries/update.exe partition vbmeta_b flash\vbmeta_b.dump 2>&1 | Select-String -Pattern '^(?!.*(libusb-dll|os_init|set_debug))'"
echo.
echo Process completed.
echo.
echo If the device remained connected the whole time and did not enter a "not found" or "not configured correctly" state, then you are good to turn it off and back on!!
echo.
echo If it did, in fact, do one of those two. Please refer to the instructions at the head of this script!
echo.
echo.
echo --------------------------------------------
echo Amlogic Flashing Script v1.0 from ThingLabs
echo --------------------------------------------
pause >nul
